
#ifndef _1_MNG_ATP_TST_h_H
#define _1_MNG_ATP_TST_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "MNG_ATP_TST_Defines.h"
#include "CRYS_AES.h"
#include "MNG_Functions.h"


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Sep 11 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MNG_ATP_TST.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/* Data struct for RKEK test function */
typedef struct TST_MNG_RKEK_TestDataStruct{	
	DxChar					  TST_Name[TST_NAME_STRING_LEN];
	DxUint16_t                TST_KeyLen;
	DxUint8_t                 TST_Key[TST_MNG_MAX_AES_KEY_SIZE];
	DxUint32_t                TST_DataLen;
	DxUint8_t                 TST_Data[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_Output[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_ExpectedOutput[TST_MNG_MAX_DATA_SIZE];
	CRYS_AES_OperationMode_t  TST_Mode;
  	CRYS_AES_IvCounter_t	  TST_IvCounter;
  	CRYS_AES_KeySize_t		  TST_KeySize;
} TST_MNG_RKEK_TestDataStruct;

/* Data struct for OEM/SJtag test functions */
typedef struct TST_MNG_PUBKey_TestDataStruct{	
	DxChar					          TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t                 TST_N[TST_MNG_MAX_DATA_SIZE];
	DxUint32_t                TST_NLen;
  DxUint32_t                TST_E;
	DxUint8_t                 TST_Data[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_Output[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_ExpectedOutput[TST_MNG_MAX_DATA_SIZE];
} TST_MNG_PUBKey_TestDataStruct;

/* Data struct for MonCounter test function */
typedef struct TST_MNG_MTC_TestDataStruct{	
	DxChar					  TST_Name[TST_NAME_STRING_LEN];
	DxUint32_t                TST_KeyLen;
	DxUint8_t                 TST_Key[DX_MNG_MAX_WRAPPED_PLATFORM_KEY_SIZE_IN_BYTES];
	DxUint32_t                TST_WrappedMTCLen;
	DxUint8_t                 TST_WrappedMTC[DX_MNG_MAX_WRAPPED_PLATFORM_KEY_SIZE_IN_BYTES];
	DxUint32_t                TST_MTCLen;
	DxUint8_t                 TST_MTC[TST_MNG_MAX_COUNTER_SIZE];
} TST_MNG_MTC_TestDataStruct;

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_RKEK      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Set the RKEK key
 * 2. Call CRYS_AES_SecretKey to encrypt data.
 * 3. Verify the results
 *    
 *  * Implements MNG ATP section 5.2 
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Set_And_Use_RKEK( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_OEM_PubKey      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Set the OEM pub key
 * 2. Build a platform key with the OEM key
 * 3. Use the platform key to PRIM encrypt and verify the results
 *    
 *  * Implements MNG ATP section 5.3 
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Set_And_Use_OEM_PubKey( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_And_Use_SJTAG_PubKey      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function sets the RKEK key and verifies it works correctly
 *  
 * Algorithm:       
 * 1. Set the SJTAG pub key
 * 2. Build a platform key with the SJTAG key
 * 3. Use the platform key to PRIM encrypt and verify the results
 *    
 *  * Implements MNG ATP section 5.4
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Set_And_Use_SJTAG_PubKey( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Monotonic_Counter      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function test the creation and usage of the monotonic counter
 *  
 * Algorithm:       
 * 1. Create AES platform wrapper key
 * 2. Create a monotonic counter with the wrapper key
 * 3. Verify the counter's value
 * 4. Increment the counter 
 * 5. Verify the counter value
 *    
 *  * Implements MNG ATP section 5.5 
 *
 ******************************************************************************/                                
DxError_t MNG_ATP_TST_Monotonic_Counter( void ); 

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Secure_State      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Verify if operation is allowed on current state - Set the RKEK to a known 
 *    vector by calling DX_MNG_SetRkekOtp API (the operation should fail on 
 *    MNG_SECURE_LCS) 
 * 3. Change the LCS to the next state by calling DX_MNG_ChangeLCS
 * 4. Repeat the test for MNG_CHIP_MANUFACTURING_LCS, MNG_DEVICE_MANUFACTURING_LCS,
 *    MNG_SECURE_LCS and MNG_RMA_LCS  
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Set_LCS_To_Secure_State( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Security_Disable      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Verify if operation is allowed on current state - Set the RKEK to a known 
 *    vector by calling DX_MNG_SetRkekOtp API (the operation should fail on 
 *    MNG_SECURITY_DISABLE_LCS) 
 * 3. Change the LCS to the next state by calling DX_MNG_ChangeLCS
 * 4. Repeat the test for MNG_CHIP_MANUFACTURING_LCS, MNG_DEVICE_MANUFACTURING_LCS,
 *    MNG_SECURITY_DISABLE_LCS and MNG_RMA_LCS  
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Set_LCS_To_Security_Disable( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Random_Vector_Test      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Generate a Random vector and save it using DX_MNG_GenerateVector API
 * 2. Generate a second Random vector and save it 
 * 3. Compare the random numbers and verify that are not equal
 * 4. Repeat the loop for X times 
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Random_Vector_Test( void );

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_WarmBootIndication_Test      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Do Snapshot after the boot (if necessary)
 * 2. Reset SEP (warm boot)
 * 3. Call CRYS_AES to verify that the CRYS is operational 
 * 4. Clear the warm boot indication by calling DX_MNG_ClearWarmBootIndication 
 *    API
 * 5. Do Snapshot
 * 6. Reset SEP (warm boot) 
 * 7. Set the RKEK to a known vector - should fail
 * 8. Call CRYS_AES to verify that the CRYS is not operational
 * 9. Do Snapshot
 * 10. Reset the SEP (cold boot)
 * 11. Call CRYS_AES to verify that the CRYS is operational again
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_WarmBootIndication_Test( void ) ;

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Display_Versions      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function display the ROM version, the RAM version and the MW package
 *  version. 
 *
 ******************************************************************************/                                

DxError_t MNG_ATP_TST_Display_Versions( void ) ;
#ifdef __cplusplus
}
#endif

#endif
